<?php
//	REF:http://www.webdesignersblog.jp/archives/2010/02/10192251.php
App::uses('Component', 'Controller');

class CommonComponent extends Component {

	public function SaveFieldModel($model_name, $check_id, $field, $value){
	    $model = ClassRegistry::init($model_name);
		$conditions = array('check_id' => $check_id);
		$id = $model->field("id", $conditions, array('id DESC'));
		$model->set('id', $id);
		$model->saveField($field, $value);
	}



	public function clearAllCache()
	{
		Cache::clear(false, '_cake_core_');
		Cache::clear(false, '_cake_model_');
		Cache::clear(false, '_cake_env_');
		// viewキャッシュ削除
		$this->clearCache();
		// dataキャッシュ削除
		//$this->clearDataCache();
	}


/**
 * Used to delete files in the cache directories, or clear contents of cache directories
 *
 * @param string|array $params As String name to be searched for deletion, if name is a directory all files in
 *   directory will be deleted. If array, names to be searched for deletion. If clearCache() without params,
 *   all files in app/tmp/cache/views will be deleted
 * @param string $type Directory in tmp/cache defaults to view directory
 * @param string $ext The file extension you are deleting
 * @return bool `true` if files found and deleted, `false` otherwise.
 */
	public function clearCache($params = null, $type = 'views', $ext = '.php') {
		if (is_string($params) || $params === null) {
			$params = preg_replace('/\/\//', '/', $params);
			$cache = CACHE . $type . DS . $params;
			if (is_file($cache . $ext)) {
				//@codingStandardsIgnoreStart
				@unlink($cache . $ext);
				//@codingStandardsIgnoreEnd
				return true;
			} elseif (is_dir($cache)) {
				$files = glob($cache . '*');
				if ($files === false) {
					return false;
				}
				foreach ($files as $file) {
					if (is_file($file) && strrpos($file, DS . 'empty') !== strlen($file) - 6) {
						//@codingStandardsIgnoreStart
						@unlink($file);
						//@codingStandardsIgnoreEnd
					}
				}
				return true;
			}
			$cache = array(
				CACHE . $type . DS . '*' . $params . $ext,
				CACHE . $type . DS . '*' . $params . '_*' . $ext
			);
			$files = array();
			while ($search = array_shift($cache)) {
				$results = glob($search);
				if ($results !== false) {
					$files = array_merge($files, $results);
				}
			}
			if (empty($files)) {
				return false;
			}
			foreach ($files as $file) {
				if (is_file($file) && strrpos($file, DS . 'empty') !== strlen($file) - 6) {
					//@codingStandardsIgnoreStart
					@unlink($file);
					//@codingStandardsIgnoreEnd
				}
			}
			return true;
		} elseif (is_array($params)) {
			foreach ($params as $file) {
				clearCache($file, $type, $ext);
			}
			return true;
		}
		return false;
	}


/**
 * データキャッシュを削除する
 */
	public function clearDataCache(){
		App::import('Core', 'Folder');
		$folder = new Folder(CACHE . 'datas' . DS);

		$files = $folder->read(true, true, true);
		foreach($files[1] as $file) {
			@unlink($file);
		}
		$Folder = new Folder();
		foreach($files[0] as $folder) {
			$Folder->delete($folder);
		}
	}








	public function DeleteDoubleCheckDT1($room_no=0, $check_id=""){
		if(!$room_no or !$check_id){
			debug("Error: room_no=".$room_no." check_id=".$check_id);
			return false;
		}

		$model = ClassRegistry::init('CheckDT1');
		$conditions = array('room_no' => $room_no, 'check_id' => $check_id);//, 'over_flag >'=>0, 'dt4_flag'=>0
		$order = array('id' => 'ASC');	//ASC | DESC
		$check = $model->find('all', array('conditions' => $conditions, 'order' => $order));
		if(empty($check)){
			return false;
		}

		for($i=0; $i<(count($check)-1); $i++){
			$model->delete($check[$i]['CheckDT1']['id']);
		}
		return true;
	}



	public function GetCartOrdQty($room_no=0, $check_id="", $order_no=0){
		$model = ClassRegistry::init('CartORD');
		if($order_no > 0){
			$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_no'=>$order_no, 'order_send_flag'=>0);
			$ord = $model->find('first', array('conditions'=>$conditions));
			if(empty($ord))
				return 0;
			else
				return $ord['CartORD']['qty'];
		}elseif($order_no == -1){
			$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_send_flag'=>0);
			$ord = $model->find('count', array('conditions'=>$conditions));
//debug($ord);
//exit();
			return $ord;
		}else{
			$conditions = array('room_no'=>$room_no, 'check_id'=>$check_id, 'order_send_flag'=>0);
			$field = array('SUM(qty) AS qty_sum');
			$ord = $model->find('all', array('fields'=>$field,'conditions'=>$conditions));
//debug($ord);
//exit();
			if(empty($ord[0][0]['qty_sum']))
				return 0;
			else
				return $ord[0][0]['qty_sum'];
		}
	}


	public function WriteLog($msg=""){
		$temp_file = TMP."logs/".date("Ymd")."debug.log";
//debug($temp_file);
//debug($path_file);
		$file = new File($temp_file);

		$line = date("Y-m-d H:i:s").": ".$msg."\n";
	   	$file->write($line, "a", true);
		$file->close();
	}

	//////////////////////////////////////////////////////////
	public function GetLeaveRemainTime($room, $check_id){
//debug($room);
//debug($check_id);
		if(!$room)
			return "roomデータなし";
		if(!$check_id)
			return "check_idデータなし";

		$check = $this->GetCheckDT1($room, $check_id);
		if($check == array())
			return "該当データなし room=".$room." checkid=".$check_id;

		$now = time();
		$dt = strtotime($check['leave_remain_time']." minute", strtotime($check['up_date']));
		$diff = (int)(($dt - $now) / 60);
		if($check['over_flag'] == 2){
			return $diff;
		}elseif($check['over_flag'] == 3){
			if($diff < 0)
				return $diff;
			else
				return $diff * -1;
		}
	}

	public function GetDrinkFreeTime($room, $check_id){
		if(!$room)
			return "roomデータなし";
		if(!$check_id)
			return "check_idデータなし";

		$check = $this->GetCheckDT1($room, $check_id);
//debug($check['drink_free_time']);
		if($check == array())
			return "該当データなし room=".$room." checkid=".$check_id;
//debug($check['drink_free_kind']);
		if($check['drink_free_kind'] == 0)
			return "";
//debug($check['drink_free_time']);
		$now = time();
		$dt = strtotime($check['drink_free_time']." minute", strtotime($check['up_date']));
		$diff = (int)(($dt - $now) / 60);
		return $diff;
	}

	public function GetCheckDT1($room, $check_id){
		$model = ClassRegistry::init('CheckDT1');
		$conditions = array('room_no' => $room, 'check_id' => $check_id);//, 'over_flag >'=>0, 'dt4_flag'=>0
		$order = array('id' => 'DESC');	//ASC | DESC
		$check = $model->find('first', array('conditions' => $conditions, 'order' => $order));
		if($check == array()){
			$conditions = array('room_no' => $room);
			$order = array('id' => 'DESC');	//ASC | DESC
			$check = $model->find('first', array('conditions' => $conditions, 'order' => $order));
			if($check == array())
				return array();
			else
				return $check['CheckDT1'];
		}else
			return $check['CheckDT1'];
	}
	//////////////////////////////////////////////////////////
	public function MoveDT1Old($room_no, $check_id, $mode=0){
//debug($room_no);
//debug($check_id);
	    $model = ClassRegistry::init('CheckDT1');
	    $old_model = ClassRegistry::init('CheckDT1Old');

		if($mode < 2){
			$order = array('up_date' => 'ASC');	//ASC | DESC
			if($mode == 0)
				$conditions = array('room_no' => $room_no, 'check_id !='=>$check_id);
			else
				$conditions = array('room_no' => $room_no, 'check_id'=>$check_id);
//debug($conditions);
			$data = $model->find('all', array('conditions'=>$conditions, 'order' => $order));
			for($i=0; $i<count($data); $i++){
				$save_data = $data[$i]['CheckDT1'];
				$id = $data[$i]['CheckDT1']['id'];
				$save_data['id'] = NULL;
//debug($save_data);
//exit();
				$old_model->save($save_data);
				$model->delete($id);
			}
		}

	    $model2 = ClassRegistry::init('CartDT7');
	    $old_model2 = ClassRegistry::init('CartDT7Old');
		//$check_id2 = $save_data['check_id'];
		$order2 = array('up_date' => 'ASC');	//ASC | DESC
		if($mode == 0)
			$conditions2 = array('room_no' => $room_no, 'check_id !='=>$check_id);
		else
			$conditions2 = array('room_no' => $room_no, 'check_id'=>$check_id);
		$data2 = $model2->find('all', array('conditions'=>$conditions2, 'order' => $order2));
		for($j=0; $j<count($data2); $j++){
			$save_data2 = $data2[$j]['CartDT7'];
			$id = $data2[$j]['CartDT7']['id'];
			$save_data2['id'] = NULL;
//debug($save_data2);
//exit();
			$old_model2->save($save_data2);
			$model2->delete($id);
		}

	    $model3 = ClassRegistry::init('CartORD');
	    $old_model3 = ClassRegistry::init('CartORDOld');
		//$check_id3 = $save_data['check_id'];
		$order3 = array('order_time' => 'ASC');	//ASC | DESC
		if($mode == 0)
			$conditions3 = array('room_no' => $room_no, 'check_id !='=>$check_id);
		else
			$conditions3 = array('room_no' => $room_no, 'check_id'=>$check_id);
		$data3 = $model3->find('all', array('conditions'=>$conditions3, 'order' => $order3));
		for($k=0; $k<count($data3); $k++){
			$save_data3 = $data3[$k]['CartORD'];
			$id = $data3[$k]['CartORD']['id'];
			$save_data3['id'] = NULL;
//debug($save_data3);
//exit();
			$old_model3->save($save_data3);
			$model3->delete($id);
		}

	}

	public function MoveModelOld($model_name){
	    $model = ClassRegistry::init($model_name);
	    $old_model = ClassRegistry::init($model_name."Old");

		if($model_name == "CartORD")
			$order = array('order_time' => 'ASC');	//ASC | DESC
		else
			$order = array('up_date' => 'ASC');	//ASC | DESC
		$data = $model->find('all', array('order' => $order));
		for($i=0; $i<count($data); $i++){
			$save_data = $data[$i][$model_name];
			$save_data['id'] = NULL;
//debug($save_data);
//exit();
			$old_model->save($save_data);
		}
		$sql = "TRUNCATE `".$model->useTable."`";
//debug($sql);
//exit();
		$ret = $model->query($sql);
	}


// $_SERVER['REMOTE_ADDR']
// $_SERVER['SERVER_ADDR']
// $_SERVER['HTTP_USER_AGENT']
// $_SERVER['HTTP_SEC_CH_UA_PLATFORM']
// $_SERVER['HTTP_SEC_CH_UA']
	public function SaveIPaddress(){
		$model = ClassRegistry::init('Config');
		$fields = array('id', 'REMOTE_ADDR');
		$conditions = array('REMOTE_ADDR' => $_SERVER['REMOTE_ADDR']);
		$conf = $model->find('first', array('fields'=>$fields, 'conditions'=>$conditions));
		if(count($conf) == 0){
			$save_array = array('id'=>NULL, 'REMOTE_ADDR'=>$_SERVER['REMOTE_ADDR'], 
				'USER_AGENT'=>$_SERVER['HTTP_USER_AGENT'], 'access_time'=>date("Y-m-d H:i:s"));
		}else{
			$save_array = array('id'=>$conf['Config']['id'], 'REMOTE_ADDR'=>$_SERVER['REMOTE_ADDR'], 
				'USER_AGENT'=>$_SERVER['HTTP_USER_AGENT'], 'access_time'=>date("Y-m-d H:i:s"));
		}
		$model->save($save_array);
	}

	public function CheckIPaddress(){
		$model = ClassRegistry::init('Config');
		$fields = array('id', 'REMOTE_ADDR');
		$conditions = array('REMOTE_ADDR' => $_SERVER['REMOTE_ADDR']);
		$n = $model->find('count', array('fields'=>$fields, 'conditions'=>$conditions));
		if($n > 0)
			return true;
		else
			return false;
	}

	public function GetFileDT6(){
		$room_no_max = $this->GetRoomNoMax();
		$fileDt6 = "RM".sprintf('%03d', $room_no_max).".DT6";
		return $fileDt6;
	}


	public function GetRoomNoMax(){
		$model = ClassRegistry::init('RoomInfo');
		$ret = $model->find('first', array('fields' => array("MAX(RoomID) as room_no_max")));
		$room_no_max = $ret[0]['room_no_max'];
		return (int)$room_no_max;
	}

	public function GetRoomrdPath($server_name=""){
		//$server_name = substr($_SERVER['SERVER_NAME'], 0, 2);
		if($server_name == "")
			$server_name =  substr($_SERVER['SERVER_NAME'], 0, strpos($_SERVER['SERVER_NAME'], ".") );

		if($server_name == "s.")
			$server_name = "s";

		if(strstr($server_name, "lo"))
			$path = "C:\\xampp\\ftp\\s\\roomord\\";
		else
			$path = "/home/bsuihzhf/public_ftp/".$server_name."/roomord/";
//debug($path);
		if(!is_dir($path)){
			$dir = new Folder();
    		if(!$dir->create($path)) {
    		    debug("エラー　dir->create");
				exit();
	   		}
		}

		return $path;
	}

	public function GetCheckID($room_no){
//debug($room_no);
		$model = ClassRegistry::init('CheckDT1');
/*
  		//$check_id = $model->field('check_id', array('room_no'=>$room_no, "CHAR_LENGTH(`check_id`)" => 0), 'id DESC');
  		$check_id = $model->field('check_id', array('room_no'=>$room_no, 'OR' => array('check_id' => '', 'check_id' => NULL)), 'id DESC');
//debug($check_id);
*/
		$orders = array('id' => 'desc');
		$conditions = array('room_no' => $room_no, 'dt4_flag' => 0);		//, 'check_id' => ''
		$check = $model->find('all', array('conditions'=>$conditions, 'order'=>$orders ));
		if(isset($check[0]['CheckDT1']['check_id']))
			$check_id = $check[0]['CheckDT1']['check_id'];
		else
			return false;
//debug($check);
//exit();
		for($i=0; $i<count($check); $i++){
			$check_id = $check[$i]['CheckDT1']['check_id'];
			if($check_id == NULL){
				continue;
			}elseif($check_id == ''){
				continue;
			}
			break;
		}
		if($check_id){
//debug($check_id);
			return $check_id;
		}
//debug($check_id);
		return false;
	}


	public function GetUnitPrice($room_no, $order_no){
		$model = ClassRegistry::init('CheckDT1');
  		$n = $model->field('unit_price_kind', array('room_no'=>$room_no), 'id DESC');
  		$drink_free_kind = $model->field('drink_free_kind', array('room_no'=>$room_no), 'id DESC');
		
		$model = ClassRegistry::init('MenuMSTR');
  		if($drink_free_kind > 0){
			$drink_free_pattern = $model->field("drink_free_kind8", array('order_no'=>$order_no));
			if(strstr($drink_free_pattern, $drink_free_kind)){
				$unit_price = 0;
			}else{
		  		$unit_price = $model->field("unitprice".($n+1), array('order_no'=>$order_no));
			}
		}else{
	  		$unit_price = $model->field("unitprice".($n+1), array('order_no'=>$order_no));
		}
		return $unit_price;
	}


	public function DecodeCheckID($check_id){
		$s = hexdec($check_id);
//debug($s);
		$st = substr($s, 0, strlen($s)-2);
		$dt = date("Y-m-d H:i:s", (int)$st);
//debug($dt);
		$r = (int)substr($s, strlen($s)-2, 2);
//debug($r);
		return "(".$dt." ".$r.")";
	
	}

	public function ResetModelID($model){	//'Check
	    $userModel = ClassRegistry::init($model);
	    //$user = $userModel->findById($userId);
//debug($userModel->useTable);
//exit();
		$sql = "set @n:=0;";
		$rtn = $userModel->query($sql);

//debug($model);
//array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
//						'CheckDT1', 'CartDT7', 'CartORD');	//, 'Menu', 'Cart', 'OldCart', 'Check', 'OldCheck'		
		$sql = "update `".$userModel->useTable."` set id=@n:=@n+1;";
		$rtn = $userModel->query($sql);

		$data = $userModel->find('first', array('fields' => array("MAX(id) as max_id")));
		return $data[0]['max_id'] +1;
	}

	public function OpenCloseTime($obj, $mode="close"){
	    $model = ClassRegistry::init('Store');
		$open_time = $model->field("open_time", array('id'=>$obj->_store_id));
		$close_time = $model->field("close_time", array('id'=>$obj->_store_id));
		if($mode=="open")
			$targetTime = strtotime(date("Y-m-d ".$open_time));
		else
			$targetTime = strtotime(date("Y-m-d ".$close_time));

		$time1 = new DateTime(date("H:i:s"));
		$time2 = new DateTime('00:00:00');
		$time3 = new DateTime($close_time);
		if(($time1 > $time2) and ($time1 < $time3))
			$targetTime = strtotime("-1 day", $targetTime);
		return date("Y-m-d H:i:s", $targetTime);
	}

	public function ConvRoomName($room_no){
		$model = ClassRegistry::init('RoomInfo');
  		$room_name = $model->field('RoomName', array('RoomID'=>$room_no));
		return $room_name;
	}



}
