<?php
//	http://localhost/psp/config/bumon
//  http://s10.piearson1.shop/psp/config/

if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require ROOT . '/app/Vendor/autoload.php';
			// ROOT = '/home/gzenrzjd/public_html/s5/psp'
//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;


use PhpOffice\PhpSpreadsheet\Writer\Pdf;


App::uses('AppController', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');

class ConfigController extends AppController {
	public $name = 'Config';
	public $uses = array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
						'CheckDT1', 'CartDT7', 'CartORD', 'Config', 'TopMenu',
						'CheckDT1Old', 'CartDT7Old', 'CartORDOld', 'Member', 'RatePlan', 'DiscountPremium');
							//, 'Menu', 'Cart', 'OldCart', 'Check', 'OldCheck'
	public $layout = 'config';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;
	public $_server_name =  "";
	public $_server_name2 =  "";

	public $_store_id = 1;
	public $_cart_id = "";
	public $_order_no = "";
	public $_room_no = "";

	public $_order_send = "";
	public $_order_time = NULL;

	public $_deliver_send = "";
	public $_deliver_time = NULL;

	public $_checkin_time = NULL;
	public $_checkout_time = NULL;

	public $_menu_id = 0;
	public $_menu_name = "";
	public $_room_use = 0;

	public $_cat1 = "";
	public $_cat2 = "";
	public $_photo_no = "";

	public $_bumon_id = "";
	public $_cat2name = "";
	public $_cat2flag = "";
	public $_up_date = "";

	public $_open_time = NULL;
	public $_close_time = NULL;
	public $_page_pattern = 0;
	public $_max_room_no = 10;

	public $_member_id = NULL;
	public $_memo = NULL;
	public $_member_no = NULL;
	public $_name = NULL;
	public $_grade = NULL;
	public $_birthday = NULL;

	public $_plan_id = NULL;
	public $_plan = NULL;
	public $_comment = NULL;
	public $_flag = NULL;
	//public $_up_date = NULL;

	public $_discount_id = NULL;
	public $_item = NULL;
	public $_kind = NULL;
	public $_value = NULL;
	public $_unit = NULL;
	public $_mode = NULL;



	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "https://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);
/********** MOD 2023/06/18 ******************************************************/
		$this->_server_name =  substr($_SERVER['SERVER_NAME'], 0, strpos($_SERVER['SERVER_NAME'], ".") );
		$this->_store_id = preg_replace('/[^0-9]/', '', $this->_server_name);
/********** MOD 2023/06/18 ******************************************************/
		if($this->_server_name == "lo")
			$this->_server_name = "s2";		//"s";
		elseif($this->_server_name == "s.")
			$this->_server_name = "s";		//"s";

		$this->set('_store_id', $this->_store_id);
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "管理画面".$this->_server_name2;
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'config', 'action' => 'member'));
	}


/*************************************************************************************************/
	public function member(){
//debug(ROOT);
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "会員管理".$this->_server_name2);
		$conditions = $this->GetMemberRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$members = $this->request->data;
//debug(count($members));
				for($i=0; $i<count($members); $i++){
					if(isset($members[$i]['Member']['id'])){
//debug($members[$i]['Member']['id']);
						$this->Member->set('id', $members[$i]['Member']['id']);

						if(!isset($members[$i]['Member']['status'])){
							$members[$i]['Member']['status'] = 0;
							$this->Member->saveField('status', 0);
						}else{
							$members[$i]['Member']['status'] = 1;
							$this->Member->saveField('status', 1);
						}
					}
				}
			}
		}
		if(isset($members[1]['Member']['current'])){
			$page = $members[1]['Member']['current'];
		}else{
			$page = 1;
		}

		$this->set('page', $page);

		$this->paginate = array(
			'Member' => array(
				'page' => 1,
				'limit' => 100,
				'order' => 'Member.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Member');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);

		if($page > 1)
			return $this->redirect(['action' => 'member', "page:".$page]);
	}

	private function GetMemberRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
		  if(isset($this->request->data['Member'])){
			$search = $this->request->data['Member'];
			if (isset($search['member_id'])){
				if($search['member_id'] > 0){
					$this->_member_id = $search['member_id'];
					$conditions['Member.id'] = $this->_member_id;
				}
			}
			if (isset($search['member_no'])){
				if($search['member_no']){
					$this->_member_no = $search['member_no'];
					$conditions['Member.member_no like'] = '%'.$this->_member_no.'%';
				}
			}
			if (isset($search['name'])){
				if($search['name']){
					$this->_name = $search['name'];
					$conditions['Member.name like'] = '%'.$this->_name.'%';
				}
			}
			if (isset($search['memo'])){
				if($search['memo']){
					$this->_memo = $search['memo'];
					$conditions['Member.memo like'] = '%'.$this->_memo.'%';
				}
			}
			if (isset($search['grade'])){
				if($search['grade']){
					$this->_grade = $search['grade'];
					$conditions['Member.grade like'] = '%'.$this->_grade.'%';
				}
			}
			if (isset($search['birthday'])){
				if($search['birthday']){
					$this->_birthday = $search['birthday'];
					$conditions['Member.birthday like'] = '%'.$this->_birthday.'%';
				}
			}
		  }
		}
		$this->set('member_id', $this->_member_id);
		$this->set('memo', $this->_memo);
		$this->set('member_no', $this->_member_no);
		$this->set('name', $this->_name);
		$this->set('grade', $this->_grade);
		$this->set('birthday', $this->_birthday);
//debug($conditions);
		return $conditions;
	}


	public function member_edit($member_id=0){
		$error_msg = "";
		$this->set('main_title', "会員管理(Member)".$this->_server_name2);
//debug($this->request->data);
		if($this->request->data){
			$member = $this->request->data['Member'];
//debug($member);
			if($member['submit'] == "削除"){
				$member_id = $member['id'];
				if($member['id'] > 0){
					$ret = $this->Member->delete($member_id);
					$this->redirect(array('controller' => 'config', 'action' => 'member'));
				}
			}

			$flag = 0;
			$error_msg = "";
			if($member['submit'] == "更新" or $member['submit'] == "新規追加"){
				if(strlen($member['member_no2']) > 0)
					$member['member_no'] = $member['member_no2'];
				if(strlen($member['grade2']) > 0)
					$member['grade'] = $member['grade2'];
				if(!isset($discount['status']))
					$member['status'] = 0;
				else
					$member['status'] = 1;
//debug($member);
//exit();
				if(strlen($member['member_no']) == 0){
					$error_msg .= "※会員番号が空白です。";
					$flag = 1;
				}

				if(strlen($member['name']) == 0){
					$error_msg .= "※会員名が空白です。";
					$flag = 1;
				}
				if(strlen($member['grade']) == 0){
					$error_msg .= "※グレードが空白です。";
					$flag = 1;
				}


				
			}

			if ($member['submit'] == "更新"){
				$member_id = $member['id'];
				if($member['id'] > 0 and $flag == 0){
					$ret = $this->Member->save($member);
					$this->redirect(array('controller' => 'config', 'action' => 'member'));
				}
			}elseif($member['submit'] == "新規追加"){
				$conditions = array('name'=>$member['name'], 'birthday'=>$member['birthday']);
				$data = $this->Member->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg .= "※同名の会員登録があります。";
					$flag = 1;
				}

				$conditions = array('member_no'=>$member['member_no']);
				$data = $this->Member->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg .= "※同じ会員番号の会員登録があります。";
					$flag = 1;
				}


				if($flag == 0){
					$member['id'] = NULL;
					$ret = $this->Member->save($member);
					$this->redirect(array('controller' => 'config', 'action' => 'member'));
				}
				$member_id = "new";
			}else{
				debug("エラー");
				exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Member");	//'

		if(strstr($member_id, "new")){
			$data['Member']['id'] = NULL;
			$data['Member']['member_no'] = NULL;
			$data['Member']['name'] = NULL;
			$data['Member']['memo'] = NULL;
			$data['Member']['grade'] = NULL;
			$data['Member']['birthday'] = NULL;
			$data['Member']['expiration'] = NULL;
			$data['Member']['usage_amount'] = 0;
			$data['Member']['visits'] = 0;
			$data['Member']['last_visit'] = NULL;
			$data['Member']['point'] = 0;
			$data['Member']['table1'] = NULL;
			$data['Member']['table2'] = NULL;
			$data['Member']['table3'] = NULL;
			$data['Member']['status'] = 0;
			$data['Member']['up_date'] = date("Y-m-d H:i:s");
			$this->set('mode', "new");
		}elseif($member_id > 0){
			$conditions = array('id'=>$member_id);
			$data = $this->Member->find('first', array('conditions'=>$conditions));
			$error_msg = "";
			$this->set('mode', "edit");
		}else{
			$data = array();
			$error_msg .= "　データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


/*************************************************************************************************/
	public function plan(){
//debug(ROOT);
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "料金プラン管理".$this->_server_name2);
		$conditions = $this->GetRatePlanRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$plans = $this->request->data;
//debug(count($plans));
				for($i=0; $i<count($plans); $i++){
					if(isset($plans[$i]['RatePlan']['id'])){
//debug($plans[$i]['RatePlan']['id']);
						$this->RatePlan->set('id', $plans[$i]['RatePlan']['id']);
						if(!isset($plans[$i]['RatePlan']['flag'])){
							$plans[$i]['RatePlan']['flag'] = 0;
							$this->RatePlan->saveField('flag', 0);
						}else{
							$plans[$i]['RatePlan']['flag'] = 1;
							$this->RatePlan->saveField('flag', 1);
						}
					}
				}
			}
		}
		if(isset($plans[1]['RatePlan']['current'])){
			$page = $plans[1]['RatePlan']['current'];
		}else{
			$page = 1;
		}

		$this->set('page', $page);

		$this->paginate = array(
			'RatePlan' => array(
				'page' => 1,
				'limit' => 100,
				'order' => 'RatePlan.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('RatePlan');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);

		if($page > 1)
			return $this->redirect(['action' => 'plan', "page:".$page]);
	}

	private function GetRatePlanRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
		  if(isset($this->request->data['RatePlan'])){
			$search = $this->request->data['RatePlan'];
			if (isset($search['plan_id'])){
				if($search['plan_id'] > 0){
					$this->_plan_id = $search['plan_id'];
					$conditions['RatePlan.id'] = $this->_plan_id;
				}
			}
			if (isset($search['plan'])){
				if($search['plan']){
					$this->_plan = $search['plan'];
					$conditions['RatePlan.plan like'] = '%'.$this->_plan.'%';
				}
			}
			if (isset($search['comment'])){
				if($search['comment']){
					$this->_comment = $search['comment'];
					$conditions['RatePlan.comment like'] = '%'.$this->_comment.'%';
				}
			}
			if (isset($search['flag'])){
				if($search['flag']){
					$this->_flag = $search['flag'];
					$conditions['RatePlan.flag'] = $this->_flag;
				}
			}
			if (isset($search['up_date'])){
				if($search['up_date']){
					$this->_up_date = $search['up_date'];
					$conditions['RatePlan.up_date '] = $this->_up_date;
				}
			}
		  }
		}
		$this->set('plan_id', $this->_plan_id);
		$this->set('plan', $this->_plan);
		$this->set('comment', $this->_comment);
		$this->set('flag', $this->_flag);
		$this->set('up_date', $this->_up_date);
//debug($conditions);
		return $conditions;
	}


	public function plan_edit($plan_id=0){
		$error_msg = "";
		$this->set('main_title', "料金プラン管理(RatePlan)".$this->_server_name2);
//debug($this->request->data);
		if($this->request->data){
			$plan = $this->request->data['RatePlan'];
//debug($plan);
			if($plan['submit'] == "削除"){
				$plan_id = $plan['id'];
				if($plan['id'] > 0){
					$ret = $this->RatePlan->delete($plan_id);
					$this->redirect(array('controller' => 'config', 'action' => 'plan'));
				}
			}

			$flag = 0;
			$error_msg = "";
			if($plan['submit'] == "更新" or $plan['submit'] == "新規追加"){
				if(!isset($discount['flag']))
					$plan['flag'] = 0;
				else
					$plan['flag'] = 1;

				if(strlen($plan['plan2']) > 0)
					$plan['plan'] = $plan['plan2'];
				if(strlen($plan['comment2']) > 0)
					$plan['comment'] = $plan['comment2'];

			}

			if ($plan['submit'] == "更新"){
				$plan_id = $plan['id'];
				if($plan['id'] > 0 and $flag == 0){
					$ret = $this->RatePlan->save($plan);
					$this->redirect(array('controller' => 'config', 'action' => 'plan'));
				}
			}elseif($plan['submit'] == "新規追加"){
				$conditions = array('plan'=>$plan['plan']);
				$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg = "※同じ料金プランの登録があります。";
					$flag = 1;
				}
				$conditions = array('plan'=>$plan['comment']);
				$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg .= "※同じコメントの登録があります。";
					$flag = 1;
				}

				if($flag == 0){
					$plan['id'] = NULL;
					$ret = $this->RatePlan->save($plan);
					$this->redirect(array('controller' => 'config', 'action' => 'plan'));
				}
				$plan_id = "new";
			}else{
				debug("エラー");
				exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("RatePlan");	//'

		if(strstr($plan_id, "new")){
			$data['RatePlan']['id'] = NULL;
			$data['RatePlan']['plan'] = NULL;
			$data['RatePlan']['name'] = NULL;
			$data['RatePlan']['comment'] = NULL;
			$data['RatePlan']['flag'] = NULL;
			$data['RatePlan']['up_date'] = date("Y-m-d H:i:s");
			$this->set('mode', "new");
		}elseif($plan_id > 0){
			$conditions = array('id'=>$plan_id);
			$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
			$error_msg = "";
			$this->set('mode', "edit");
		}else{
			$data = array();
			$error_msg .= "　データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


/*************************************************************************************************/
	public function discount(){
//debug(ROOT);
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "割引割増管理".$this->_server_name2);
		$conditions = $this->GetDiscountPremiumRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$discounts = $this->request->data;
//debug(count($discounts));
				for($i=0; $i<count($discounts); $i++){
					if(isset($discounts[$i]['DiscountPremium']['id'])){
//debug($discounts[$i]['DiscountPremium']['id']);
//debug($discounts[$i]['DiscountPremium']['mode']);
						$this->DiscountPremium->set('id', $discounts[$i]['DiscountPremium']['id']);
						if(!isset($discounts[$i]['DiscountPremium']['mode'])){
							$discounts[$i]['DiscountPremium']['mode'] = 0;
							$this->DiscountPremium->saveField('mode', 0);
						}else{
//debug($discounts[$i]['DiscountPremium']['mode']);
							$discounts[$i]['DiscountPremium']['mode'] = 1;
							$this->DiscountPremium->saveField('mode', 1);
						}
//debug($this->DiscountPremium->field('mode', array('id'=>$discounts[$i]['DiscountPremium']['id'])));
//exit();
					}
				}
			}
		}
		if(isset($discounts[1]['DiscountPremium']['current'])){
			$page = $discounts[1]['DiscountPremium']['current'];
		}else{
			$page = 1;
		}

		$this->set('page', $page);

		$this->paginate = array(
			'DiscountPremium' => array(
				'page' => 1,
				'limit' => 100,
				'order' => 'DiscountPremium.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('DiscountPremium');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);

		if($page > 1)
			return $this->redirect(['action' => 'discount', "page:".$page]);
	}

	private function GetDiscountPremiumRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
		  if(isset($this->request->data['DiscountPremium'])){
			$search = $this->request->data['DiscountPremium'];
			if (isset($search['discount_id'])){
				if($search['discount_id'] > 0){
					$this->_discount_id = $search['discount_id'];
					$conditions['DiscountPremium.id'] = $this->_discount_id;
				}
			}
			if (isset($search['item'])){
				if($search['item']){
					$this->_item = $search['item'];
					$conditions['DiscountPremium.item like'] = '%'.$this->_item.'%';
				}
			}
			if (isset($search['kind'])){
				if($search['kind']){
					$this->_kind = $search['kind'];
					$conditions['DiscountPremium.kind like'] = '%'.$this->_kind.'%';
				}
			}
			if (isset($search['name'])){
				if($search['name']){
					$this->_name = $search['name'];
					$conditions['DiscountPremium.name like'] = '%'.$this->_name.'%';
				}
			}
			if (isset($search['value'])){
				if($search['value']){
					$this->_value = $search['value'];
					$conditions['DiscountPremium.value'] = $this->_value;
				}
			}
			if (isset($search['unit'])){
				if($search['unit']){
					$this->_unit = $search['unit'];
					$conditions['DiscountPremium.unit like'] = '%'.$this->_unit.'%';
				}
			}
			if (isset($search['mode'])){
				if($search['mode']){
					$this->_mode = $search['mode'];
					$conditions['DiscountPremium.mode'] = $this->_mode;
				}
			}
		  }
		}
		$this->set('discount_id', $this->_discount_id);
		$this->set('item', $this->_item);
		$this->set('kind', $this->_kind);
		$this->set('name', $this->_name);
		$this->set('value', $this->_value);
		$this->set('unit', $this->_unit);
		$this->set('mode', $this->_mode);
//debug($conditions);
		return $conditions;
	}


	public function discount_edit($discount_id=0){
		$error_msg = "";
		$this->set('main_title', "割引割増管理(DiscountPremium)".$this->_server_kind2);
//debug($this->request->data);
		if($this->request->data){
			$discount = $this->request->data['DiscountPremium'];
//debug($discount);
			if($discount['submit'] == "削除"){
				$discount_id = $discount['id'];
				if($discount['id'] > 0){
					$ret = $this->DiscountPremium->delete($discount_id);
					$this->redirect(array('controller' => 'config', 'action' => 'discount'));
				}
			}
			
			$flag = 0;
			$error_msg = "";
			if($discount['submit'] == "更新" or $discount['submit'] == "新規追加"){
				if(!isset($discount['mode']))
					$discount['mode'] = 0;
				else
					$discount['mode'] = 1;
				
				if(strlen($discount['item2']) > 0)
					$discount['item'] = $discount['item2'];
				if(strlen($discount['kind2']) > 0)
					$discount['kind'] = $discount['kind2'];
				if(strlen($discount['name2']) > 0)
					$discount['name'] = $discount['name2'];
				if(strlen($discount['unit2']) > 0)
					$discount['unit'] = $discount['unit2'];


			}
			if ($discount['submit'] == "更新"){
				$discount_id = $discount['id'];
				if($discount['id'] > 0 and $flag == 0){
					$ret = $this->DiscountPremium->save($discount);
					$this->redirect(array('controller' => 'config', 'action' => 'discount'));
				}
debug($flag);
debug($error_msg);
exit();
			}elseif($discount['submit'] == "新規追加"){
				$conditions = array('name'=>$discount['name']);
				$data = $this->DiscountPremium->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg .= "※同じ割引名称の登録があります。";
					$flag = 1;
				}

				if($flag == 0){
					$discount['id'] = NULL;
					$ret = $this->DiscountPremium->save($discount);
					$this->redirect(array('controller' => 'config', 'action' => 'discount'));
				}
				$discount_id = "new";
			}else{
				debug("エラー");
				exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("DiscountPremium");	//'

		if(strstr($discount_id, "new")){
			$data['DiscountPremium']['id'] = NULL;
			$data['DiscountPremium']['item'] = NULL;
			$data['DiscountPremium']['kind'] = NULL;
			$data['DiscountPremium']['name'] = NULL;
			$data['DiscountPremium']['value'] = NULL;
			$data['DiscountPremium']['unit'] = NULL;
			$data['DiscountPremium']['mode'] = NULL;
			$this->set('mode', "new");
		}elseif($discount_id > 0){
			$conditions = array('id'=>$discount_id);
			$data = $this->DiscountPremium->find('first', array('conditions'=>$conditions));
			$error_msg = "";
			$this->set('mode', "edit");
		}else{
			$data = array();
			$error_msg .= "　データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


/*************************************************************************************************/


	public function bumon(){
//debug(ROOT);
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理(Bumon)".$this->_server_name2);
		$conditions = $this->GetBumonRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$bumons = $this->request->data;
				for($i=0; $i<count($bumons); $i++){
					if(isset($bumons[$i]['Bumon']['id'])){
						$this->Bumon->set('id', $bumons[$i]['Bumon']['id']);
						if(!isset($bumons[$i]['Bumon']['cat2flag'])){
							$bumons[$i]['Bumon']['cat2flag'] = 0;
							$this->Bumon->saveField('cat2flag', 0);
						}else{
							$bumons[$i]['Bumon']['cat2flag'] = 1;
							$this->Bumon->saveField('cat2flag', 1);
						}

						if(!isset($bumons[$i]['Bumon']['flag16'])){
							$bumons[$i]['Bumon']['flag16'] = 0;
							$this->Bumon->saveField('flag16', 0);
						}else{
							$bumons[$i]['Bumon']['flag16'] = 1;
							$this->Bumon->saveField('flag16', 1);
						}
					}


/*
					if(isset($bumons[$i]['Bumon']['id'])){
//debug($bumons[$i]['Bumon']['id']);
						$this->Bumon->set('id', $bumons[$i]['Bumon']['id']);
						if(isset($bumons[$i]['Bumon']['flag16'])){
							if($bumons[$i]['Bumon']['flag16'] == 1){
								$this->Bumon->saveField('flag16', 1);
								continue;
							}
						}
						$this->Bumon->saveField('flag16', 0);
					}
*/
				}//end of for
			}
		}
		if(isset($bumons[1]['Bumon']['current'])){
			$page = $bumons[1]['Bumon']['current'];
		}else{
			$page = 1;
		}

		$this->set('page', $page);

		$this->paginate = array(
			'Bumon' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Bumon.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Bumon');
		$this->set('data', $data);

		//**********************
		$fields = array('cat1');
		$conditions = array();
		$group = array('cat1');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat1_array[$i] = $menu[$i]['MenuMSTR']['cat1'];
			$this->set('cat1_array', $cat1_array);
		}
		//$cat1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('cat2');
		if(isset($search['cat1'])){
			if($search['cat1'])
				$conditions = array('cat1' => $search['cat1']);
		}else
			$conditions = array();
		$group = array('cat2');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat2_array[$i] = $menu[$i]['MenuMSTR']['cat2'];
			$this->set('cat2_array', $cat2_array);
		}
		//**********************
		
		$this->set('error_msg', $error_msg);

		if($page > 1)
			return $this->redirect(['action' => 'bumon', "page:".$page]);
	}

	private function GetBumonRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
		  if(isset($this->request->data['Bumon'])){
			$search = $this->request->data['Bumon'];
			if (isset($search['bumon_id'])){
				if($search['bumon_id'] > 0){
					$this->_bumon_id = $search['bumon_id'];
					$conditions['Bumon.id'] = $this->_bumon_id;
				}
			}
			if (isset($search['cat1'])){
				if($search['cat1']){
					$this->_cat1 = $search['cat1'];
					$conditions['Bumon.cat1 like'] = $this->_cat1;
				}
			}
			if (isset($search['cat2'])){
				if($search['cat2']){
					$this->_cat2 = $search['cat2'];
					$conditions['Bumon.cat2 like'] = $this->_cat2;
				}
			}
			if (isset($search['cat2name'])){
				if($search['cat2name']){
					$this->_cat2name = $search['cat2name'];
					$conditions['Bumon.cat2name like'] = '%'.$this->_cat2name.'%';
				}
			}
			if (isset($search['cat2flag'])){
				if($search['cat2flag']){
					$this->_cat2flag = $search['cat2flag'];
					$conditions['Bumon.cat2flag like'] = '%'.$this->_cat2flag.'%';
				}
			}
		  }
		}
		$this->set('bumon_id', $this->_bumon_id);
		$this->set('cat2name', $this->_cat2name);
		$this->set('cat1', $this->_cat1);
		$this->set('cat2', $this->_cat2);
		$this->set('cat2flag', $this->_cat2flag);
//debug($conditions);
		return $conditions;
	}

	public function bumon_edit($bumon_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(Bumon)".$this->_server_name2);
//debug($this->request->data);
		if($this->request->data){
			$bumon = $this->request->data['Bumon'];
//debug($bumon);
			if ($bumon['submit'] == "削除"){
				//$this->Bumon->delete($bumon['id']);
				$this->redirect(array('controller' => 'config', 'action' => 'bumon'));

			}elseif ($bumon['submit'] == "更新"){
				if($bumon['id'] > 0){
					if(!isset($bumon['cat2flag']))
						$bumon['cat2flag'] = 0;
					else
						$bumon['cat2flag'] = 1;
					if(!isset($bumon['flag16']))
						$bumon['flag16'] = 0;
					else
						$bumon['flag16'] = 1;

					$bumon_id = $bumon['id'];
//debug($bumon);
					$ret = $this->Bumon->save($bumon);
				}
				$this->redirect(array('controller' => 'config', 'action' => 'bumon'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Bumon");	//'

		if($bumon_id > 0){
			$conditions = array('id'=>$bumon_id);
			$data = $this->Bumon->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function bumon_img($bumon_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(部門)".$this->_server_name2);

		if($this->request->data){
//debug($this->request->data);			
			$bumon_id = $this->request->data['Bumon']['id'];
			$cat1_no = $this->request->data['Bumon']['cat1'];
			$cat2_no = $this->request->data['Bumon']['cat2'];
			$photo_no = $this->request->data['Bumon']['photo_no'];
			$img_file = $this->request->data['Bumon']['img_file'];
			$img_file_tmp = $this->request->data['Bumon']['img_file_tmp'];

			if(strstr($this->request->data['submit'], "写真をアップする")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
//画像の保存
					//画像保存先のパス
					$path = IMAGES;
					$image = $this->request->data['Post']['image'];
//debug($image);
					move_uploaded_file($image['tmp_name'], $img_file_tmp);		//$image['name']
					$this->ImageResize($img_file_tmp, $img_file, 1010, 384);

					$this->Bumon->set('id', $bumon_id);
					$this->Bumon->saveField('up_date', date("Y-m-d H:i:s"));

				}
			}
		}
//debug($bumon_id);
		if($bumon_id > 0){
			$conditions = array('id'=>$bumon_id);
			$data = $this->Bumon->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	private function ImageResize($img_src, $img_des, $width_des=1010, $height_des=384){
		list($width, $hight) = getimagesize($img_src); // 元の画像名を指定してサイズを取得
		$baseImage = imagecreatefromjpeg($img_src); // 元の画像から新しい画像を作る準備
		$image = imagecreatetruecolor($width_des, $height_des); // サイズを指定して新しい画像のキャンバスを作成
		
		//$transparent = imagecolorallocatealpha($image, 0, 0, 0, 0); // 透明度を持つ色を作成
		$white = imagecolorallocate( $image, 255, 255, 255 );
		imagefill($image, 0, 0, $white);    // 塗りつぶす

		$width_des2 = $height_des * ($width/$hight);

		if($width_des > 577)
			$x_des = ($width_des - $width_des2) / 4;	// master の左オフセット
		else
			$x_des = ($width_des - $width_des2) / 2;	// bumon の左オフセット
		// 画像のコピーと伸縮
		imagecopyresampled($image, $baseImage, $x_des, 0, 0, 0, $width_des2, $height_des, $width, $hight);

		// コピーした画像を出力する
		imagejpeg($image , $img_des);
//debug($img_src);
//debug($img_des);
//exit();
		return;
		
		
		//resizeimg.classを読み込む
		App::import('Vendor', 'ResizeimgClass', array('file' => 'Resize' . DS . 'resizeimg.class.php'));
		$RI = new resize_image();   //クラスの作成
		
   		$save_path = $img_file;  //保存される画像のパス
   		$resize_path = $img_file;  //resizeimg.class.phpから見た画像ファイルへのパス

		//画像の作成(縦・横最大640px)
		//画像縦横サイズを取得
		$wh_size = getimagesize($resize_path);
		$w = $wh_size[0];  // width
		$h = $wh_size[1];    //height
		if ($w >= $h){
			//$width = $width_no;
			//$height = 'auto';
			$type = 'wfit';
		}else{
			//$width = 'auto';
			//$height = 384;
			$type = 'hfit';
		}
		$resize_image = $RI->disp_resize_img_path($resize_path, $width, $height, $type);
		//画像をリサイズしたら元の画像を削除
		//$file = new File($save_path);
		//$file->delete();
	}


/*************************************************************************************************/

	public function menu(){
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);
//debug($this->request->data);
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$menus = $this->request->data;
//debug(count($menus));
				for($i=0; $i<count($menus); $i++){
					if(isset($menus[$i]['MenuMSTR']['id'])){
//debug($menus[$i]['MenuMSTR']['id']);
						$this->MenuMSTR->set('id', $menus[$i]['MenuMSTR']['id']);
						if(!isset($menus[$i]['MenuMSTR']['menu_flag'])){
							$menus[$i]['MenuMSTR']['menu_flag'] = 0;
							$this->MenuMSTR->saveField('menu_flag', 0);
						}else{
							$menus[$i]['MenuMSTR']['menu_flag'] = 1;
							$this->MenuMSTR->saveField('menu_flag', 1);
						}
					}
				}
			}
		}
		if(isset($menus[1]['MenuMSTR']['current'])){
			$page = $menus[1]['MenuMSTR']['current'];
		}else{
			$page = 1;
		}
		

		$conditions = $this->GetMenuRequestData();

		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'MenuMSTR' => array(
				'page' => 1,
				'limit' => 100,
				'order' => 'MenuMSTR.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('MenuMSTR');
		$this->set('data', $data);

		//**********************
		$fields = array('cat1');
		$conditions = array();
		$group = array('cat1');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat1_array[$i] = $menu[$i]['MenuMSTR']['cat1'];
			$this->set('cat1_array', $cat1_array);
		}
		//$cat1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('cat2');
		if(isset($search['cat1'])){
			if($search['cat1'])
				$conditions = array('cat1' => $search['cat1']);
		}else
			$conditions = array();
		$group = array('cat2');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat2_array[$i] = $menu[$i]['MenuMSTR']['cat2'];
			$this->set('cat2_array', $cat2_array);
		}
		//**********************

		$this->set('error_msg', $error_msg);
		


/*
$this->Paginator->numbers(array(
'first' => '', //ページ数が多いとき最初のページを出すか（数字で指定）
'last' => '',//ページ数が多いとき最後のページを出すか（数字で指定）
'before'=>'',//ページ番号の前に出力する文字を指定
'after'=>'',//ページ番号の後に出力する文字を指定
'modulus'=>'',//ページ番号を幾つ表示するか（デフォルト値：8）
'separator'=>'',//ページ番号を区切る文字列（デフォルト値：|）
'ellipsis'=>'',//省略される時に表示される文字列（デフォルト値：・・・）
'tag'=>'',//ページ番号を囲むタグ（デフォルト値：設定無し）
'class'=>'',//上記タグのクラス名を設定（デフォルト値：設定無し）
'currentTag'=>'',//表示中のページ番号のタグを設定（デフォルト値：null）
'currentClass'=>'',//表示中のページ番号のクラスを設定（デフォルト値：current）
)
);
*/
	}


	public function menu_edit($menu_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

		if($this->request->data){
			if($this->request->data['submit'] == "更新"){
//debug($this->request->data);
//debug($this->request->data['MenuMSTR']);
				$menu = $this->request->data['MenuMSTR'];
				if (isset($menu['id'])){
					if($menu['id'] > 0){
						if(!isset($menu['menu_flag']))
							$menu['menu_flag'] = 0;
						else
							$menu['menu_flag'] = 1;

						$menu_id = $menu['id'];
						$ret = $this->MenuMSTR->save($menu);
						$this->redirect(array('controller' => 'config', 'action' => 'menu'));
					}
  				}
			}
			$menu_id = $this->request->data['MenuMSTR']['id'];
			$cat1_no = $this->request->data['MenuMSTR']['cat1'];
			$cat2_no = $this->request->data['MenuMSTR']['cat2'];

			if(strstr($this->request->data['submit'], "アップロード")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
					$post = $this->request->data['Post']['image'];
					$tmp=$post['tmp_name'];
//debug($tmp);
					if(is_uploaded_file($tmp)) {
/*						$file_name = basename($post['name']);
						if(strstr($this->request->data['submit'], "商品"))
							$file = WWW_ROOT.'img'.DS."1".DS.'item'.DS.$cat1_no.DS.$file_name;
						elseif(strstr($this->request->data['submit'], "カテゴリ2"))
							$file = WWW_ROOT.'img'.DS."1".DS.'mcate'.DS.$cat1_no.DS.$cat2_no.".jpg";
						elseif(strstr($this->request->data['submit'], "カテゴリ1"))
							$file = WWW_ROOT.'img'.DS."1".DS.'lcate'.DS.$cat1_no.".jpg";
						elseif(strstr($this->request->data['submit'], "ページHEADER"))
							$file = WWW_ROOT.'img'.DS."1".DS.'main'.DS."header.jpg";
						elseif(strstr($this->request->data['submit'], "ページTOP"))
							$file = WWW_ROOT.'img'.DS."1".DS.'main'.DS."main.jpg";
						else
							debug("");
//debug($file);
						if (move_uploaded_file($tmp, $file)) {
							if(strstr($this->request->data['submit'], "商品")){
								$this->MenuMSTR->set('id', $menu_id);
								$this->MenuMSTR->saveField('photo_no', $file_name);
							}
						}else{
							debug("Upload Error");
							$error_msg = "Upload Error";
						}
*/
					}
				}
			}
		}
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


	public function menu_img($menu_id=0){		//画像UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

		if($this->request->data){
//debug($this->request->data);			
			$menu_id = $this->request->data['MenuMSTR']['id'];
			$cat1_no = $this->request->data['MenuMSTR']['cat1'];
			$cat2_no = $this->request->data['MenuMSTR']['cat2'];
			$photo_no = $this->request->data['MenuMSTR']['photo_no'];
			$img_file = $this->request->data['MenuMSTR']['img_file'];
			$img_file_tmp = $this->request->data['MenuMSTR']['img_file_tmp'];

			if(strstr($this->request->data['submit'], "写真をアップする")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
//画像の保存
					//画像保存先のパス
					$path = IMAGES;
					$image = $this->request->data['Post']['image'];
//debug($image);
					move_uploaded_file($image['tmp_name'], $img_file_tmp);		//$image['name']
					$this->ImageResize($img_file_tmp, $img_file, 576, 384);

					$this->MenuMSTR->set('id', $menu_id);
					$this->MenuMSTR->saveField('up_date', date("Y-m-d H:i:s"));

				}
			}
		}
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}



/*************************************************************************************************/

	
	public function store(){
		$this->set('main_title', "店舗/部屋管理".$this->_server_name2);
		$error_msg = "";
		$order_no = 1;
		
		$new_id = $this->Common->ResetModelID("Store");	//'
		$conditions = array();
//debug($this->request->data);
		if($this->request->data){
			$search = $this->request->data['Store'];
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$order_no = $search['order_no'];
					$conditions['Store.id'] = $order_no;
				}
			}

		}
		
		$this->paginate = array(
			'Store' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Store.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Store');
		$this->set('data', $data);

//'RoomGroup', 'RoomInfo', 
		//$order = array('id' => 'ASC');	//ASC | DESC
		//$conditions = array();
		$room_info = $this->RoomInfo->find('all');//, array('conditions' => $conditions, 'order' => $order)
		$this->set('room_info', $room_info);
//debug($room_group);

		$room_group = $this->RoomGroup->find('all');//, array('conditions' => $conditions, 'order' => $order)
		$this->set('room_group', $room_group);


		$this->set('error_msg', $error_msg);
	}

	public function store_edit($store_id=0){
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$store = $this->request->data['Store'];
//debug($store);
			if ($store['submit'] == "削除"){
				//$this->Store->delete($store['id']);
				$this->redirect(array('controller' => 'config', 'action' => 'store'));

			}elseif ($store['submit'] == "更新"){
				if($store['id'] > 0){
					$store_id = $store['id'];
//debug($store);
					$ret = $this->Store->save($store);
					$this->redirect(array('controller' => 'config', 'action' => 'store'));
				}
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Store");	//'

		if($store_id > 0){
			$conditions = array('id'=>$store_id);
			$data = $this->Store->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


	public function store_new(){
		$error_msg = "";
		$order_no = 0;
		if($this->request->data){
//debug($this->request->data);
			$store = $this->request->data['Store'];
			if (isset($store['id'])){
				if($store['id'] > 0){
					$order_no = $store['id'];
					$save_array = array (
						'id'=>NULL, 'store_name'=>$store['store_name'],
						'open_time'=>$store['open_time'], 'close_time'=>$store['close_time'],
						//'page_pattern'=>$store['page_pattern'], 
						'max_room_no'=>$store['max_room_no'],
						'tel'=>$store['tel'], 'note1'=>$store['note1'], 'note2'=>$store['note2']);
//debug($save_array);
//exit();
					$ret = $this->Store->save($save_array);
				}
				$this->redirect(array('controller' => 'config', 'action' => 'store'));
				exit();
			}
		}
		$data['Store']['id'] = $this->Common->ResetModelID("Store");	//'
//debug($data['Store']['id']);

		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function store_edit2($info_id=0){
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$info = $this->request->data['RoomInfo'];
			if ($info['submit'] == "削除"){
				$this->RoomInfo->delete($info['id']);
				$this->redirect(array('controller' => 'config', 'action' => 'store'));

			}elseif ($info['submit'] == "更新"){
				if($info['id'] > 0){
					$info_id = $info['id'];
					$ret = $this->RoomInfo->save($info);
				}
				$this->redirect(array('controller' => 'config', 'action' => 'store'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("RoomInfo");	//'

		if($info_id > 0){
			$conditions = array('id'=>$info_id);
			$data = $this->RoomInfo->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function store_edit3($group_id=0){
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$group = $this->request->data['RoomGroup'];
			if ($group['submit'] == "削除"){
				$this->RoomGroup->delete($group['id']);
				$this->redirect(array('controller' => 'config', 'action' => 'store'));

			}elseif ($group['submit'] == "更新"){
				if($group['id'] > 0){
					$group_id = $group['id'];
					$ret = $this->RoomGroup->save($group);
				}
				//$this->redirect(array('controller' => 'config', 'action' => 'store'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("RoomGroup");	//'

		if($group_id > 0){
			$conditions = array('id'=>$group_id);
			$data = $this->RoomGroup->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

//	http://localhost/psp/config/top_menu0/
	public function top_menu0(){
		$this->autoRender = false;	//View File なし
		for($i=14; $i<100; $i++){
			$savearray = array('id'=>$i);
			$this->TopMenu->save($savearray);
		}
debug("end");
	}

/*************************************************************************************************/


	public function top_menu($cmd=0, $id=0){
		$this->set('main_title', "クイック・メニュー管理".$this->_server_name2);
		$error_msg = "";
		$order_no = 1;
		
		//$new_id = $this->Common->ResetModelID("TopMenu");	//'
		$conditions = array();
//debug($this->request->data);
		if($this->request->data){
//debug($this->request->data);
//exit();
			if($this->request->data['submit'] == "更新"){
				$top_menus = $this->request->data;
//debug(count($top_menus));
				for($i=0; $i<count($top_menus); $i++){
					if(isset($top_menus[$i]['TopMenu']['id'])){
//debug($top_menus[$i]['TopMenu']['id']);
						$this->TopMenu->set('id', $top_menus[$i]['TopMenu']['id']);

						if(!isset($top_menus[$i]['TopMenu']['flag'])){
							$top_menus[$i]['TopMenu']['flag'] = 0;
							$this->TopMenu->saveField('flag', 0);
						}else{
							$top_menus[$i]['TopMenu']['flag'] = 1;
							$this->TopMenu->saveField('flag', 1);
						}
					}
				}
			}

/*
			if(isset($this->request->data['submit'])){
				if(strstr($this->request->data['submit'], "補正")){
					$this->TopMenuCompensation();
				}
			}
*/
			if(isset($this->request->data['TopMenu'])){
				$search = $this->request->data['TopMenu'];
				if (isset($search['order_no'])){
					if($search['order_no'] > 0){
						$order_no = $search['order_no'];
						$conditions['TopMenu.id'] = $order_no;
					}
				}
			}
		}
		
		if($cmd==1){
			$flag = $this->TopMenu->field('flag', array('id'=>$id));
			$this->TopMenu->set('id', $id);
			if($flag)
				$this->TopMenu->saveField('flag', 0);
			else
				$this->TopMenu->saveField('flag', 1);
		}
		$this->paginate = array(
			'TopMenu' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'TopMenu.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('TopMenu');
		$this->set('data', $data);

//'RoomGroup', 'RoomInfo', 
		//$order = array('id' => 'ASC');	//ASC | DESC
		//$conditions = array();
		//$room_info = $this->RoomInfo->find('all');//, array('conditions' => $conditions, 'order' => $order)
		//$this->set('room_info', $room_info);
//debug($room_group);

		//$room_group = $this->RoomGroup->find('all');//, array('conditions' => $conditions, 'order' => $order)
		//$this->set('room_group', $room_group);


		$this->set('error_msg', $error_msg);
	}

	private function TopMenuCompensation(){
		$top_menu = $this->TopMenu->find('all', array('conditions'=>array('flag' => '1')));
//debug($menu);
		for($i=0; $i<count($top_menu); $i++){
			$id = $top_menu[$i]['TopMenu']['id'];
			$cat_name = $top_menu[$i]['TopMenu']['cat_name'];
			$cat_name = str_replace('＜br＞', '', $cat_name);
			$cat_name = str_replace('<br>', '', $cat_name);

			$conditions = array('cat2name like' => '%'.$cat_name.'%', 'cat2'=>'1');
			$bumon = $this->Bumon->find('first', array('conditions'=>$conditions));
//debug($bumon);
			if(count($bumon) > 0){
				$this->TopMenu->set('id', $id);
				$this->TopMenu->saveField('cat1', $bumon['Bumon']['cat1']);
				$this->TopMenu->saveField('cat2', $bumon['Bumon']['cat2']);
			}else{
				$conditions = array('cat2name like' => '%'.$cat_name.'%', 'cat2 >'=>'0');
				$bumon = $this->Bumon->find('first', array('conditions'=>$conditions));
				if(count($bumon) > 0){
					$this->TopMenu->set('id', $id);
					$this->TopMenu->saveField('cat1', $bumon['Bumon']['cat1']);
					$this->TopMenu->saveField('cat2', $bumon['Bumon']['cat2']);
				}else{
					$this->TopMenu->set('id', $id);
					$this->TopMenu->saveField('cat1', 0);
					$this->TopMenu->saveField('cat2', 0);
					$this->TopMenu->saveField('flag', 0);
//debug($bumon);
//debug($conditions);
//exit();
				}
			}
		}
	}

	public function top_menu_edit($top_menu_id=0){
		$this->set('main_title', "クイック・メニュー管理(編集)".$this->_server_name2);
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$top_menu = $this->request->data['TopMenu'];
//debug($top_menu);
			if ($top_menu['submit'] == "削除"){
				//$this->TopMenu->delete($top_menu['id']);
				$this->redirect(array('controller' => 'config', 'action' => 'top_menu'));

			}elseif ($top_menu['submit'] == "更新"){
				if(!isset($top_menu['flag']))
					$top_menu['flag'] = 0;
				else
					$top_menu['flag'] = 1;

				if($top_menu['id'] > 0){
					$top_menu_id = $top_menu['id'];
//debug($top_menu);
					$ret = $this->TopMenu->save($top_menu);
				}
				$this->redirect(array('controller' => 'config', 'action' => 'top_menu'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("TopMenu");	//'

		if($top_menu_id > 0){
			$conditions = array('id'=>$top_menu_id);
			$data = $this->TopMenu->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}



	private function GetMenuRequestData(){
		$conditions = array();
//debug($this->request->data);
		if (isset($this->request->data['MenuMSTR'])){
			$search = $this->request->data['MenuMSTR'];
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$this->_order_no = $search['order_no'];
					$conditions['MenuMSTR.order_no'] = $this->_order_no;
				}
			}
			if (isset($search['menu_id'])){
				if($search['menu_id'] > 0){
					$this->_menu_id = $search['menu_id'];
					$conditions['MenuMSTR.id'] = $this->_menu_id;
				}
			}
			if (isset($search['cat1'])){
				if($search['cat1']){
					$this->_cat1 = $search['cat1'];
					$conditions['MenuMSTR.cat1 like'] = $this->_cat1;
				}
			}
			if (isset($search['cat2'])){
				if($search['cat2']){
					$this->_cat2 = $search['cat2'];
					$conditions['MenuMSTR.cat2 like'] = $this->_cat2;
				}
			}
			if (isset($search['menu_name'])){
				if($search['menu_name']){
					$this->_menu_name = $search['menu_name'];
					$conditions['MenuMSTR.menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}
			if (isset($search['photo_no'])){
				if($search['photo_no']){
					$this->_photo_no = $search['photo_no'];
					$conditions['MenuMSTR.photo_no like'] = '%'.$this->_photo_no.'%';
				}
			}
		}
		$this->set('order_no', $this->_order_no);
		$this->set('menu_id', $this->_menu_id);
		$this->set('menu_name', $this->_menu_name);
		$this->set('cat1', $this->_cat1);
		$this->set('cat2', $this->_cat2);
		$this->set('photo_no', $this->_photo_no);
//debug($conditions);
		return $conditions;
	}








	private function GetStore(){
		$store = $this->Store->find('first', array('conditions' => array('Store.id' => $this->_order_no)));
		//if (! $this->data){ throw new NotFoundException(); }
		if(!$store){ echo "エラーGetStore"; debug("Error!!!"); }
//debug($store);
		$this->_order_no = $store['Store']['id'];
		$this->set('_order_no', $this->_order_no);

		$this->_store_name = $store['Store']['store_name'];
		$this->set('_store_name', $this->_store_name);

		//$this->_page_pattern = $store['Store']['page_pattern'];
		//$this->set('_page_pattern', $this->_page_pattern);

		//$_max_room_no = $store['Store']['max_room_no'];
		//$this->set('_max_room_no', $this->_max_room_no);

		$this->set('store', $store);
	}










/** ============================================================================================================= */
/** ============================================================================================================= */
/** ============================================================================================================= */
	public function download_member(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Member.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Member'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','会員番号','会員名','メモ','グレード','誕生日','有効期限',
			'利用金額','来店回数','最終来店日','ポイント',
			'テーブル1','テーブル2','テーブル3','状態','更新日時');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Member->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	public function download_plan(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_RatePlan.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'RatePlan'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','プラン名','コメント','有効･無効','更新日時');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->RatePlan->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	public function download_discount(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_DiscountPremium.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'DiscountPremium'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','対象','種類','名称','設定値','単位','モード');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->DiscountPremium->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}


//	'RatePlan', 'DiscountPremium');

	//https://s5.oierson1.shop/psp/config/download
	public function download_menu(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_MenuMSTR.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'MenuMSTR'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','注文番号','カテゴリ1','カテゴリ2','写真ファイル番号','メニュー名','単価1',
			'単価2','単価3','単価4','単価5','単価6','単価7','単価8','単価9','単価10',
			'飲み放題種類','販売状態','flag16','更新日時');



		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	//https://s5.oierson1.shop/psp/config/download
	public function download_bumon(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Bumon.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Bumon'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','部門番号','分類番号','部門・分類名称','表示/非表示','flag16','登録時間');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Bumon->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	//https://s5.oierson1.shop/psp/config/download_store
	public function download_store(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Store.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Store'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','店舗名','開店時間','閉店時間','最大部屋番号','電話番号',
			'msg1','msg2','msg3','msg4','msg5','msg6','msg7','msg8','msg9','msg10','msg11',
			'更新日時');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Store->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	public function download_room_i(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_RoomInfo.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'RoomInfo'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','部屋ID','グループID','部屋名','注文番号','状態',
			'更新日時');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->RoomInfo->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	public function download_room_g(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_RoomGroup.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'RoomGroup'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','グループID','グループ名','更新日時');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->RoomGroup->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	public function download_top_menu(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_TopMenu.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'TopMenu'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','部門番号','分類番号','メニュー名','有効/無効');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->TopMenu->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}



	private function download_sub($items, $data, $output_file_path, $outputFile){
		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		//$book->getDefaultStyle()->getFont()->setName( 'ＭＳ ゴシック' );
		$book->getDefaultStyle()->getFont()->setName( 'HG丸ｺﾞｼｯｸM-PRO' );
		$book->getDefaultStyle()->getFont()->setSize( 12 );

 		//$sheet->setTitle(date("Y年m月d日 H時i分s秒"));
// 		$sheet->setTitle(date("Sheet1"));

		//=============================================================
		$row = 1;
		foreach ($items as $col => $value) {
        	$sheet->setCellValueByColumnAndRow($col+1, $row, $value);
			
			$objStyle = $sheet->getStyleByColumnAndRow($col+1, $row);	// スタイルオブジェクト取得([B2]セル)
			$objFill = $objStyle->getFill();	// フィルオブジェクト取得([B2]セル)
			$objFill->setFillType(Fill::FILL_SOLID);	// 背景のタイプを「塗つぶし」に設定
			$objFill->getStartColor()->setARGB('4000FF00');	// 背景色を「赤」に設定
		}


		$rowOffset = 2;
		for($i=0; $i<count($data); $i++){
			$data1 = $data[$i];
//debug($data1);
			$this->WriteExcel($sheet, $data1, $rowOffset);
			$rowOffset++;
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);
//exit();

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}



	private function WriteExcel($sheet, $data, $rowOffset){
		foreach ($data as $row => $fields) {
//debug($fields);
//debug($row);
//exit();
//		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 1;
			    foreach ($fields as $field => $value) {
//debug($col);
//debug($row);
//debug($rowOffset);
//debug($col);
//debug($value);
					
        			$sheet->setCellValueByColumnAndRow($col++, 0 + $rowOffset, $value);
//exit();
				}
//exit();
//    		}
		}
	}


/** ============================================================================================================= */
/** ============================================================================================================= */
/** ============================================================================================================= */
	public function upload_member(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Member/Member.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','member_no','name','memo','grade','birthday','expiration','usage_amount',
							'visits','last_visit','point','table1','table2','table3','status','up_date');
					
					$data = $this->ReadExcell($file_path, $fields);

					$this->Member->truncate();
					$this->Member->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'member'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}

	public function upload_plan(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/RatePlan/RatePlan.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','plan','comment','flag','up_date');
					$data = $this->ReadExcell($file_path, $fields);

					$this->RatePlan->truncate();
					$this->RatePlan->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'plan'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}

	public function upload_discount(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/DiscountPremium/DiscountPremium.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','item','kind','name','value','unit','mode');
					$data = $this->ReadExcell($file_path, $fields);

					$this->DiscountPremium->truncate();
					$this->DiscountPremium->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'discount'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}


	public function upload_menu(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/MenuMSTR/MenuMSTR.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','order_no','cat1','cat2','photo_no','menu_name',
						'unitprice1','unitprice2','unitprice3','unitprice4','unitprice5',
						'unitprice6','unitprice7','unitprice8','unitprice9','unitprice10',
						'drink_free_kind8','menu_flag','flag16','up_date');
					$data = $this->ReadExcell($file_path, $fields);

					$this->MenuMSTR->truncate();
					$this->MenuMSTR->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'menu'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
/*
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
*/
	}



	public function upload_bumon(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Bumon/Bumon.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','cat1','cat2','cat2name','cat2flag','flag16','up_date');
					$data = $this->ReadExcell($file_path, $fields);

					$this->Bumon->truncate();
					$this->Bumon->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'bumon'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}

	public function upload_store(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Store/Store.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','store_name','open_time','close_time','max_room_no','tel',
						'msg1','msg2','msg3','msg4','msg5','msg6','msg7','msg8','msg9','msg10','msg11',
						'up_date' );
					$data = $this->ReadExcell($file_path, $fields);

					$this->Store->truncate();
					$this->Store->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'store'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}

	public function upload_room_i(){		//EXCELL UPLOAD		RoomInfo		RoomGroup
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/RoomInfo/RoomInfo.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','RoomID','GroupID','RoomName','OrderNo','status',
						'up_date' );
					$data = $this->ReadExcell($file_path, $fields);

					$this->RoomInfo->truncate();
					$this->RoomInfo->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'store'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}


	public function upload_room_g(){		//EXCELL UPLOAD		RoomInfo		RoomGroup
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/RoomGroup/RoomGroup.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','GroupID','GroupName','up_date' );
					$data = $this->ReadExcell($file_path, $fields);

					$this->RoomGroup->truncate();
					$this->RoomGroup->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'store'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}


	public function upload_top_menu(){		//EXCELL UPLOAD		RoomInfo		TopMenu
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/TopMenu/TopMenu.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','cat1','cat2','cat_name','flag');
					$data = $this->ReadExcell($file_path, $fields);

					$this->TopMenu->truncate();
					$this->TopMenu->saveAll($data);
					$this->redirect(array('controller' => 'config', 'action' => 'top_menu'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}





	private function ReadExcell($file_path, $fields){
//debug($file_path);
//debug($fields);
//exit();
		if(!file_exists($file_path)){
			debug("ファイルが無い：".$file_path);
			exit();
		}
		
		$reader = new Reader();
		$spreadsheet = $reader->load($file_path); // ファイル名を指定

		$sheet = $spreadsheet->getActiveSheet();
		//$sheet = $spreadsheet->getSheetByName('Worksheet'); // 読み込むシートを指定
		//$sheet = $spreadsheet->getSheet(0);

		$lastrow = $sheet->getHighestRow(); //200などの数字
		$lastcolname = $sheet->getHighestColumn(); //AZなどの文字列
		$lastcol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($lastcolname); //これで数字になる

//debug($lastrow);
//debug($lastcolname);
//debug($lastcol);
//debug(count($fields));
//exit();
		$data1 = array();
		for($row=2; $row<=$lastrow; $row++){
			for($col=1; $col<=$lastcol; $col++){
				$data1 = array_merge($data1, [$fields[$col-1] => $sheet->getCellByColumnAndRow($col,$row)->getValue()]);
			}
			$data1['id'] = $row - 1;
			$data[$row - 2] = $data1;
		}

/*
		$i = 0;
		$data = array();
		foreach ($sheet->getRowIterator() as $row) {
			$j = 0;
			$data1=array();
			foreach($sheet->getColumnIterator() as $column){
				$data1 = array_merge($data1, [$fields[$j] => $sheet->getCell($column->getColumnIndex() . ($row->getRowIndex()+1))->getValue()]);	//.PHP_EOL;
				$j++;
			}
			if($data1[$fields[2]] == null)
				break;
			$data1['id'] = $i+1;
			$data[$i] = $data1;
debug($data1);
debug($data[$i][$fields[2]]);
exit();
			$i++;
		}
*/

//debug($data[0]);
//debug($data[1]);
//debug($data[count($data)-2]);
//debug($data[count($data)-1]);
//exit();
		return $data;
		//PhpSpreadsheet
	}

/** ============================================================================================================= */


	public function show_constants(){
		debug(APP);
		debug(APP_DIR);
		debug(APPLIBS);
		debug(CACHE);
		debug(CAKE);
		debug(CAKE_CORE_INCLUDE_PATH);
		debug(CORE_PATH);
		debug(CSS);
		debug(CSS_URL);
		debug(DS);
		debug(FULL_BASE_URL);
		debug(IMAGES);
		debug(IMAGES_URL);
		debug(JS);
		debug(JS_URL);
		debug(LOGS);
		debug(ROOT);
		debug(TESTS);
		debug(TMP);
		debug(VENDORS);
		debug(WEBROOT_DIR);
		debug(WWW_ROOT);
		debug();
		debug(TIME_START);
	}

	private function array_to_string($arr){
		$s = "";
//debug($arr);
		foreach ($arr as $key => $value)
			$s .= "/".$key.":".$value;
		return $s;
	}



/*

//	http://localhost/psp/config/export_excel
//  http://s.piearson.shop/psp/config/export_excel
	public function export_excel($model=''){
		//$this->autoRender = false;	//View File なし
		if($model == "MenuMSTR")
			$outputFile = "_menus.xlsx";
		elseif($model == "Cart")
			$outputFile = "_carts.xlsx";
		else{
			debug("Error");
			exit();
		}
			
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'psp'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		
		if($model == "MenuMSTR"){
			$fields = array();
			$conditions = array('order_no'=>$this->_order_no);
			$group = array();
			$orders = array('id');
			$data = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
			//$items = array('id','order_no','cat1','cat1_no','cat2','cat2_no','category3','cat3_no','menu_name','unit_price','photo_no','not_use');
			$items = array('id','店舗id','カテゴリ1','cat1_no','カテゴリ2','cat2_no','カテゴリ3','cat3_no','商品名','単価','写真ファイル','未使用');
		}elseif($model == "Cart"){
//debug($this->_menu_id);
//exit();
			$conditions = $this->GetCartRequestData();

			$fields = array();
			//$conditions = array('order_no'=>$this->_order_no);
			$group = array();
			$orders = array('id');
			$data = $this->Cart->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
			$items = array('id','受付id','店舗id','部屋番号','テーブル番号','メニューid','メニュー名','単価','数量','金額','税金','合計',
				'注文済','注文時間','配膳済','配膳時間','催促');
		}

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

	public function import_excel(){
		$this->autoRender = false;	//View File なし
		if ($this->request->data){
//debug($this->request->data);
			$post = $this->request->data['Post']['image'];
			$tmp=$post['tmp_name'];
//debug($tmp);
			if(is_uploaded_file($tmp)) {
				$file_name = basename($post['name']);
				$file = WWW_ROOT.'files'.DS.'psp'.DS.$file_name;
//debug($file);
//exit();
				if (move_uploaded_file($tmp, $file)) {
					$this->ReadExcel($file);
				}else{
					debug("Upload Error");
					$error_msg = "Upload Error";
				}
			}
		}
	
	}











	public function get_pos_data(){
//debug($this->_server_name2);
		$path = $this->Common->GetRoomrdPath();
//debug($path);
		$dir = new Folder($path);
    	$files = $dir->read();
//debug($files);
		for($i=0; $i<count($files[1]); $i++){
			$this->read_file($path.$files[1][$i]);
		}
exit();
		
	}
	
	private function read_file($path_file){
		$file_info = pathinfo($path_file);
		$ext = $file_info['extension'];
		$filename = $file_info['filename'];
		$room_no = (int)substr($filename, 2);
debug($room_no);

		$file = new File($path_file);
	    $contents = $file->read();
		$contents = str_replace('\n', '', $contents);
debug($contents);
		if($ext == "DT1"){	//S2 00089 0456 02 00 0000 0
			$over_flag = (int)substr($contents, 1, 1);	//2 or 3 超過0分から
			$leave_remain_time = (int)substr($contents, 2, 5);	//退出残り時間（分単位）
			$entry_close_time = (int)substr($contents, 7, 4);	//入室時から閉店までの時間（分単位）
			$people = (int)substr($contents, 11, 2);	//入数
			$drink_free = (int)substr($contents, 14, 1);	//飲み放題種類
			$drink_free_time = (int)substr($contents, 15, 4);	//飲み放題残り時間
echo $over_flag."/".$leave_remain_time."/".$entry_close_time."/".$people."/".$drink_free."/".$drink_free_time."/";			
		}elseif($ext == "DT4" and strstr($contents, "S0")){
			$checkout = 2;
		}elseif($ext == "DT7"){	//R 001678 00174 002  [0004 02 00516]  [0005 01 00472]
			$total = (int)substr($contents, 1, 6);	//料金合計
			$room_charge = (int)substr($contents, 7, 5);	//室料
			$products = (int)substr($contents, 12, 3);	//商品明細点数

			$order_no = "";
			$qty = "";
			$price = "";
			$m = 15;
			$n = 19;
			$l = 21;
			for($i=0; $i<$products; $i++){
				if($i <> 0){
					$order_no .= "|";
					$qty .= "|";
					$price .= "|";
				}
				$order_no .= (int)substr($contents, $m, 4);	//オーダーNO
				$qty .= (int)substr($contents, $n, 2);	//数量
				$price .= (int)substr($contents, $l, 5);	//金額
				$n += 11;
				$m += 11;
				$l += 11;
			}
echo $total."/".$room_charge."/".$products."/".$order_no."/".$qty."/".$price;			
		
exit();		
		}
	}
	




	private function GetCartORDRequestData(){
		$conditions = array();
		$conditions['room_no >'] = 0;
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['CartORD'];
//debug($search);

			if (isset($search['cart_id'])){
				if($search['cart_id'] > 0){
					$this->_cart_id = $search['cart_id'];
					$conditions['id'] = $this->_cart_id;
				}
			}
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$this->_order_no = $search['order_no'];
					$conditions['order_no'] = $this->_order_no;
				}
			}
			if (isset($search['room_no'])){
				if($search['room_no'] > 0){
					$this->_room_no = $search['room_no'];
					$conditions['room_no'] = $this->_room_no;
				}
			}

			if (isset($search['menu_name'])){
				if($search['menu_name'] != ""){
//debug($search);
					$this->_menu_name = $search['menu_name'];
					$conditions['menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}

			if (isset($search['order_no'])){
				if($search['order_no'] != ""){
//debug($search);
					$this->_order_no = $search['order_no'];
					$conditions['order_no'] = $this->_order_no;
				}
			}
			if (isset($search['order_send'])){
				if($search['order_send'] != ""){
//debug($search);
					$this->_order_send = $search['order_send'];
					$conditions['order_send'] = $this->_order_send;
				}
			}

		}
		$this->set('cart_id', $this->_cart_id);
		$this->set('room_no', $this->_room_no);
		$this->set('order_no', $this->_order_no);
		$this->set('order_send', $this->_order_send);
		
		$this->set('menu_name', $this->_menu_name);
//debug($conditions);
		return $conditions;
	}



*/


}
